﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_29
{
    public class Program
    {
        public static void Main()
        {
            Employee employee = new Employee("Inigo", "Montoya") 
                { Title = "Maniak komputerowy", Salary = "Za niskie" };

            System.Console.WriteLine(
                "{0} {1} ({2}): {3}",
                employee.FirstName,
                employee.LastName,
                employee.Title,
                employee.Salary);
        }
    }

    class Employee
    {
        // Konstruktor w klasie Employee
        public Employee(string firstName, string lastName)
        {
            FirstName = firstName;
            LastName = lastName;
        }

        public string FirstName { get; set; }
        public string LastName { get; set; }
        public string? Salary { get; set; } = "Za niskie";
        public string? Title { get; set; }
        public Employee? Manager { get; set; }

        // Właściwość Name
        public string Name
        {
            get
            {
                return FirstName + " " + LastName;
            }
            set
            {
                // Podział przypisanej wartości na 
                // imię i nazwisko.
                string[] names;
                names = value.Split(new char[] { ' ' });
                if(names.Length == 2)
                {
                    FirstName = names[0];
                    LastName = names[1];
                }
                else
                {
                    // Zgłaszanie wyjątku, jeśli nie
                    // przypisano imienia i nazwiska.
                    throw new System.ArgumentException(
                        $"Przypisana wartość '{ value }' jest nieprawidłowa");
                }
            }
        }
    }
}
