// Pole niedopuszczające null nie jest zainicjowane. Rozważ deklarację pola dopuszczającego null
#pragma warning disable CS8618
// Metoda Main nie używa wszystkich elementów z klasy Employee; w wersji produkcyjnej byłoby inaczej
#pragma warning disable CS0649
// Wyłączone, ponieważ nie wprowadzono jeszcze inicjalizatorów obiektów
#pragma warning disable IDE0017 
// Ignorowanie dodawania modyfikatora readonly, ponieważ nie został on jeszcze wprowadzony
#pragma warning disable IDE0044


namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_15
{
    public class Program
    {
        public static void Main()
        {
            Employee employee = new Employee();

            employee.FirstName = "Inigo";
            employee.LastName = "Montoya";

            // ...

            // Pole Password jest prywatne, dlatego 
            // nie można uzyskać do niego dostępu spoza klasy.
            // Console.WriteLine(
            //    ("Password = {0}", employee.Password);
        }
        // ...
    }

    public class Employee
    {
        public string FirstName;
        public string LastName;
        public string? Salary;
        // Niezaszyfrowane hasła są tu używane tylko w celach edukacyjnych;
        // nie zaleca się stosowania tego podejścia.
        private string Password;  // Bez inicjowania (konstruktory nie zostały jeszcze omówione)
        private bool IsAuthenticated;

        public bool Logon(string password)
        {
            if(Password == password)
            {
                IsAuthenticated = true;
            }
            return IsAuthenticated;
        }

        public bool GetIsAuthenticated()
        {
            return IsAuthenticated;
        }
        // ...
    }
}
