// Klasy IsolatedStorage znajdują się w przestrzeni nazw System.IO.IsolatedStorage.

using (IsolatedStorageFile f =
       IsolatedStorageFile.GetMachineStoreForDomain())
using (var s = new IsolatedStorageFileStream ("hi.txt",FileMode.Create,f))
using (var writer = new StreamWriter (s))
  writer.WriteLine ("Witaj, świecie!");

// Odczyt danych z magazynu.

using (IsolatedStorageFile f =
       IsolatedStorageFile.GetMachineStoreForDomain())
using (var s = new IsolatedStorageFileStream ("hi.txt", FileMode.Open, f))
using (var reader = new StreamReader (s))
  Console.WriteLine (reader.ReadToEnd());        // Witaj, świecie!