[Serializable] public class Team : ISerializable
{
  public string Name;
  public List<Person> Players;

  public virtual void GetObjectData (SerializationInfo si,
                                     StreamingContext sc)
  {
    si.AddValue ("Name", Name);
    si.AddValue ("PlayerData", Players.ToArray());
  }

  public Team() {}
  
  protected Team (SerializationInfo si, StreamingContext sc)
  {
    Name = si.GetString ("Name");

    // Deserializacja Players na postać tablicy, aby odpowiadała serializacji.
    Person[] a = (Person[]) si.GetValue ("PlayerData", typeof (Person[]));

    // Konstrukcja nowego egzemplarza List na podstawie tablicy.
    Players = new List<Person> (a);
  }
}