public class WeakDelegate<TDelegate> where TDelegate : class
{
  class MethodTarget
  {
    public readonly WeakReference Reference;
    public readonly MethodInfo Method;

    public MethodTarget (Delegate d)
    {
      Reference = new WeakReference (d.Target);
      Method = d.Method;
    }
  }

  List<MethodTarget> _targets = new List<MethodTarget>();

  public WeakDelegate()
  {
    if (!typeof (TDelegate).IsSubclassOf (typeof (Delegate)))
      throw new InvalidOperationException
        ("TDelegate musi być typem delegatu.");
  }

  public void Combine (TDelegate target)
  {
    if (target == null) return;

    foreach (Delegate d in (target as Delegate).GetInvocationList())
      _targets.Add (new MethodTarget (d));
  }

  public void Remove (TDelegate target)
  {
    if (target == null) return;
    foreach (Delegate d in (target as Delegate).GetInvocationList())
    {
      MethodTarget mt = _targets.Find (w => 
        d.Target.Equals (w.Reference.Target) && 
        d.Method.MethodHandle.Equals (w.Method.MethodHandle));

      if (mt != null) _targets.Remove (mt);
    }
  }

  public TDelegate Target
  {
    get
    {
      var deadRefs = new List<MethodTarget>();
      Delegate combinedTarget = null;

      foreach (MethodTarget mt in _targets.ToArray())
      {
        WeakReference target = mt.Reference;
        if (target != null && target.IsAlive)
        {
          var newDelegate = Delegate.CreateDelegate (
            typeof (TDelegate), mt.Reference.Target, mt.Method);
            
          combinedTarget = Delegate.Combine (combinedTarget, newDelegate);
        }
        else
          deadRefs.Add (mt);
      }

      foreach (MethodTarget mt in deadRefs)   // Usunięcie z _targets
        _targets.Remove (mt);                 // martwych odwołań.

      return combinedTarget as TDelegate;
    }
    set
    {
      _targets.Clear();
      Combine (value);
    }
  }
}
