DriveInfo c = new DriveInfo ("C");       // Sprawdzenie napędu C:.

long totalSize = c.TotalSize;            // Wielkość wyrażona w bajtach.
long freeBytes = c.TotalFreeSpace;       // Ignoruje nałożone ograniczenia na przestrzeń dyskową.
long freeToMe  = c.AvailableFreeSpace;   // Uwzględnia nałożone ograniczenia na przestrzeń dyskową.

foreach (DriveInfo d in DriveInfo.GetDrives())    // Wszystkie zdefiniowane napędy.
{
  Console.WriteLine (d.Name);             // C:\
  Console.WriteLine (d.DriveType);        // Fixed
  Console.WriteLine (d.RootDirectory);    // C:\

  if (d.IsReady)   // Jeżeli napęd nie jest gotowy, obie poniższe
                   // właściwości spowodują zgłoszenie wyjątku.
  {
    Console.WriteLine (d.VolumeLabel);    // The Sea Drive.
    Console.WriteLine (d.DriveFormat);    // NTFS.
  }
}