FileInfo fi = new FileInfo (@"c:\temp\PlikInfo.txt");
Console.WriteLine (fi.Exists);         // false

using (TextWriter w = fi.CreateText())
  w.Write ("Dowolny tekst");

Console.WriteLine (fi.Exists);         // false (nadal)
fi.Refresh();
Console.WriteLine (fi.Exists);         // true

Console.WriteLine (fi.Name);           // FileInfo.txt
Console.WriteLine (fi.FullName);       // c:\temp\PlikInfo.txt
Console.WriteLine (fi.DirectoryName);  // c:\temp
Console.WriteLine (fi.Directory.Name); // temp
Console.WriteLine (fi.Extension);      // .txt
Console.WriteLine (fi.Length);         // 9

fi.Encrypt();
fi.Attributes ^= FileAttributes.Hidden;   // (Zmiana wartości atrybutu oznaczającego ukrycie).
fi.IsReadOnly = true;

Console.WriteLine (fi.Attributes);    // ReadOnly,Archive,Hidden,Encrypted
Console.WriteLine (fi.CreationTime);

fi.MoveTo (@"c:\temp\PlikInfoX.txt");

DirectoryInfo di = fi.Directory;
Console.WriteLine (di.Name);             // temp
Console.WriteLine (di.FullName);         // c:\temp
Console.WriteLine (di.Parent.FullName);  // c:\
di.CreateSubdirectory ("Podkatalog");