﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter10.Listing10_19
{
    using System;
    using System.IO;

    public class Program
    {
        private WeakReference Data;

        public FileStream GetData()
        {
            FileStream data = (FileStream)Data.Target;

            if(data != null)
            {
                return data;
            }
            else
            {
                // Wczytywanie danych.
                // …

                // Tworzenie słabej referencji dla obiektu
                // data, co pozwala ją później zastosować.
                Data.Target = data;
            }
            return data;
        }

        public static void Main()
        {
            Console.WriteLine("Bez danych wyjściowych.");
        }
    }
}