﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter08.Listing08_04
{
    using System;
    using Listing08_02;

    public class Program
    {
        public static void Main()
        {
            string[] values;
            Contact contact1, contact2 = null;

            // ...

            // BŁĄD: nie można wywołać właściwości ColumnValues() bezpośrednio
            //           dla obiektu typu Contact.
            // values = contact1.ColumnValues;

            // Najpierw trzeba zrzutować obiekt na interfejs IListable.
            values = ((IListable)contact2).ColumnValues;
            // ...
        }
    }

    public class Contact : PdaItem, IListable, IComparable
    {
        // ...
        public Contact(string name)
            : base(name)
        {
        }

        #region IComparable Members
        /// <summary>
        /// 
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>
        /// Mniej niż zero — dana instancja ma wartość mniejszą niż obj. 
        /// Zero — dana instancja ma wartość równą obj.
        /// Więcej niż zero — dana instancja ma wartość większą niż obj. 
        /// </returns>
        public int CompareTo(object obj)
        {
            int result;
            Contact contact = obj as Contact;

            if(obj == null)
            {
                // Dana instancja ma wartość większą niż obj. 
                result = 1;
            }
            else if (obj.GetType() != typeof(Contact))
            {
                // Użycie w komunikacie operatora nameof z C# 6.0, aby
                // zapewnić spójność nazwy typu.
                throw new ArgumentException(
                  $"Parametr nie jest typu { nameof(Contact) }",
                    nameof(obj));
            }
            else if(Contact.ReferenceEquals(this, obj))
            {
                result = 0;
            }
            else
            {
                result = LastName.CompareTo(contact.LastName);
                if(result == 0)
                {
                    result = FirstName.CompareTo(contact.FirstName);
                }
            }
            return result;
        }
        #endregion

        #region IListable Members
        string[] IListable.ColumnValues
        {
            get
            {
                return new string[] 
          {
              FirstName,
              LastName,
              Phone,
              Address
          };
            }
        }
        #endregion

        protected string LastName { get; set; }
        protected string FirstName { get; set; }
        protected string Phone { get; set; }
        protected string Address { get; set; }
    }
}