﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter20.Listing20_09
{
    using System;
    using System.Reflection;
    using System.Threading;

    class Program
    {
        public static void Main()
        {
            // Określa, czy jest to pierwsza instancja aplikacji.
            bool firstApplicationInstance;

            // Tworzenie nazwy muteksu na podstawie
            // pełnej nazwy podzespołu.
            string mutexName =
                Assembly.GetEntryAssembly().FullName;

            using(Mutex mutex = new Mutex(false, mutexName,
                 out firstApplicationInstance))
            {

                if(!firstApplicationInstance)
                {
                    Console.WriteLine(
                        "Ta aplikacja już działa.");
                }
                else
                {
                    Console.WriteLine("Wciśnij ENTER, aby zakończyć");
                    Console.ReadLine();
                }
            }
        }
    }
}
