﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter14.Listing14_05
{
    using System;

    public class Thermostat
    {
        // Nadawca zdarzeń
        public Action<float> OnTemperatureChange { get; set; }

        public float CurrentTemperature
        {
            get { return _CurrentTemperature; }
            set
            {
                if(value != CurrentTemperature)
                {
                    _CurrentTemperature = value;
                    // Jeśli istnieją subskrybenci,
                    // należy ich powiadomić o zmianach temperatury
                    // za pomocą skierowanego do nich wywołania.
                    OnTemperatureChange?.Invoke(value);     // C# 6.0
                }
            }
        }

        private float _CurrentTemperature;
    }
}