namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_23
{
    class Program
    {
        static void Main()
        {
            Employee employee1 = new Employee();
            employee1.Initialize(42);
            // BD: nie mona uy waciwoci ani indeksera 'Employee.Id' 
            // w tym kontekcie, poniewa setter jest niedostpny.
            //employee1.Id = "490";       // Jeli przeniesiesz kod poza komentarz, nie skompiluje si.
        }
    }

    class Employee
    {
        public void Initialize(int id)
        {
            // Przypisanie wartoci waciwoci Id.
            Id = id.ToString();
        }

        // ...
        // Deklaracja waciwoci Id.
        public string Id
        {
            get => _Id;
            // Od wersji C# 2.0 dozwolone jest dodawanie modyfikatora dostpu.
            private set => _Id = value;
        }
        private string _Id;
    }
}
