namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter05.Listing05_17
{
    using System;
    using System.IO;

    public class Program
    {
        public static void Main()
        {
            string fullName;

            // ...

            // Wywoanie metody Combine() z czterema argumentami.
            fullName = Combine(
              Directory.GetCurrentDirectory(),
              "bin", "config", "index.html");
            Console.WriteLine(fullName);

            // 

            // Wywoanie metody Combine() z tylko trzema argumentami.
            fullName = Combine(
              Environment.SystemDirectory,
              "Temp", "index.html");
            Console.WriteLine(fullName);

            // 

            // Wywoanie metody Combine() z argumentem w postaci tablicy.
            fullName = Combine(
                new string[] {
                    $"C:{Path.DirectorySeparatorChar}", "Data",
                    "HomeDir", "index.html" });
            Console.WriteLine(fullName);
            // ...
        }

        static string Combine(params string[] paths)
        {
            string result = string.Empty;
            foreach(string path in paths)
            {
                result = System.IO.Path.Combine(result, path);
            }
            return result;
        }
    }
}