﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter13.Listing13_18
{
    using System;

    public class Program
    {
        public static void Main()
        {
            // Kontrawariancja
            Action<object> broadAction =
                (object data) =>
                {
                    Console.WriteLine(data);
                };

            Action<string> narrowAction = broadAction;

            // Kowariancja
            Func<string> narrowFunction =
                () => Console.ReadLine();

            Func<object> broadFunction = narrowFunction;

            // Połączenie kontrawariancji i kowariancji.
            Func<object, string> func1 =
                (object data) => data.ToString();

            Func<string, object> func2 = func1;
        }
    }
}