﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter10.Listing10_12
{
    using System;
    using System.Collections.Generic;
    using Microsoft.Extensions.CommandLineUtils;

    public sealed class Program
    {
        public static void Main(string[] args)
        {
            CommandLineApplication commandLineApplication =
                new CommandLineApplication(throwOnUnexpectedArg: false);
            CommandArgument name = commandLineApplication.Argument(
      "name", "Podaj imię i nazwisko pozdrawianej osoby.");
            CommandOption greeting = commandLineApplication.Option(
              "-$|-g |--greeting <pozdrowienie>",
              "Wyświetlane pozdrowienie. Używany jest tu łańcuch znaków"
              + " formatowania, gdzie człon '{name}' jest"
              + " zastępowany imieniem i nazwiskiem.",
            CommandOptionType.SingleValue);
            commandLineApplication.HelpOption("-? | -h | --help");
            commandLineApplication.Execute(args);
            if (!greeting.HasValue())
            {
                Console.WriteLine($"Witaj, { name.Value }.");

            }
            else
            {
                Console.WriteLine(
                    greeting.Value().Replace("{name}", name.Value));
            }
        }
    }
}