namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_13
{
    // Dodanie przestrzeni nazw IO.
    using System.IO;
    using Listing06_12;

    class DataStorage
    {
        // Zapis obiektu employee w pliku o nazwie
        // odpowiadajcej imieniu i nazwisku pracownika.
        // Kod do obsugi bdw zosta pominity.
        public static void Store(Employee employee)
        {
            // Tworzenie obiektu typu FileStream z nazw pliku 
            // FirstNameLastName.dat. Parametr FileMode.Create powoduje 
            // utworzenie nowego pliku lub zastpienie zawartoci istniejcego.
            FileStream stream = new FileStream(
              employee.FirstName + employee.LastName + ".dat",
              FileMode.Create);

            // Tworzenie obiektu typu StreamWriter na potrzeby zapisu
            // tekstu w obiekcie typu FileStream.
            StreamWriter writer = new StreamWriter(stream);

            // Zapis wszystkich danych dotyczcych pracownika.
            writer.WriteLine(employee.FirstName);
            writer.WriteLine(employee.LastName);
            writer.WriteLine(employee.Salary);

            // Zamyka obiekt typu StreamWriter i powizany z nim strumie.
            writer.Dispose(); // Automatycznie zamyka strumie.
        }
        // ...
    }
}
