﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.IO;
using System;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter05.Listing05_12.Tests
{
    [TestClass]
    public class ProgramTests
    {
        [TestMethod]
        public void Main_NoArgs_ExpectErrors()
        {
            string[] args = new string[0];
            string view =
@"BŁĄD: należy podać adres URL i nazwę pliku.
Użytkowanie: Downloader.exe <URL> <nazwa_docelowego_pliku>";

            IntelliTect.TestTools.Console.ConsoleAssert.Expect(view,
            () =>
            {
                Program.Main(args);
            });
        }

        [TestMethod]
        public void Main_GoodArgs_DownloadFile()
        {
            string[] args = { "http://google.com", Path.Combine(Directory.GetCurrentDirectory(), "destination.txt") };

            try
            {
                Assert.AreEqual(0, Program.Main(args));
            }
            catch (AggregateException exception) when(exception.InnerException.GetType() == typeof(System.Net.Http.HttpRequestException))
            {
                Assert.Inconclusive("Nie można pobrać pliku. Sprawdź łącze internetowe.");
            }
        }
    }
}