namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter03.Listing03_25
{
    public class ProgrammingLanguages
    {
        public static void Main()
        {
            string[] languages = new string[]{
                "C#", "COBOL", "Java",
                "C++", "Visual Basic", "Pascal",
                "Fortran", "Lisp", "J#"};

            System.Array.Sort(languages);

            string searchString = "COBOL";
            int index = System.Array.BinarySearch(
                languages, searchString);
            System.Console.WriteLine(
                "Jzyk przyszoci, "
                + $"{ searchString }, jest dostpny pod indeksem { index }.");

            System.Console.WriteLine();
            System.Console.WriteLine(
                $"{ "Pierwszy element",-20 }\t{ "Ostatni element",-20 }");
            System.Console.WriteLine(
                $"{ "-------------",-20 }\t{ "------------",-20 }");
            System.Console.WriteLine(
                    $"{ languages[0],-20 }\t{ languages[languages.Length - 1],-20 }");
            System.Array.Reverse(languages);
            System.Console.WriteLine(
                    $"{ languages[0],-20 }\t{ languages[languages.Length - 1],-20 }");
            // Zauwa, e ponisza instrukcja nie usuwa elementw z tablicy.
            // Zamiast tego do wszystkich elementw przypisywana jest warto domylna.
            System.Array.Clear(languages, 0, languages.Length);
            System.Console.WriteLine(
                    $"{ languages[0],-20 }\t{ languages[languages.Length - 1],-20 }");
            System.Console.WriteLine(
                $"Po wywoaniu Clear wielko tablicy to: { languages.Length }");
        }
    }
}

