using IntelliTect.TestTools.Console;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter15.Listing15_12.Tests
{
    [TestClass]
    public class ProgramTests
    {
        [TestMethod]
        public void Listing14_15_Test()
        {
            // Niezbdne z powodu bdw w platformie MSTest - jako biecy katalog
            // ustawiany jest katalog z plikie wykonywalnym MSTest, a nie katalog
            // z podzespoem.
            Directory.SetCurrentDirectory(Path.GetDirectoryName(
                typeof(Program).GetTypeInfo().Assembly.Location));

            //string expectedPattern = $@"{ Directory.GetCurrentDirectory() }{Path.DirectorySeparatorChar}*";
            string expectedPattern = $@"{ Directory.GetCurrentDirectory() }{ 
                $"{Path.DirectorySeparatorChar}"}*";
            int expectedItemCount = Directory.EnumerateFiles(
                    Directory.GetCurrentDirectory(), "*").Count();
            string output = ConsoleAssert.Execute(null, () =>
            {
                Program.Main();
            });

            IEnumerable<string> outputItems = output.Split(
                new string[] { Environment.NewLine }, StringSplitOptions.None);

            Assert.AreEqual<int>(
                expectedItemCount, outputItems.Count());
            foreach (string item in outputItems)
            {
                Assert.IsTrue(item.IsLike(expectedPattern, '?'));
            }
        }
    }
}
