﻿using System;
using System.Diagnostics;
using static System.Console;
using static System.Diagnostics.Process;

namespace CS7
{
   public static class Nagrywanie
   {
      static Stopwatch stoper = new Stopwatch();
      static long fizyczneBajtyPrzed = 0;
      static long wirtualneBajtyPrzed = 0;

      public static void Start()
      {
         GC.Collect();
         GC.WaitForPendingFinalizers();
         GC.Collect();
         fizyczneBajtyPrzed = GetCurrentProcess().WorkingSet64;
         wirtualneBajtyPrzed = GetCurrentProcess().VirtualMemorySize64;
         stoper.Restart();
      }

      public static void Stop()
      {
         stoper.Stop();
         long fizyczneBajtyPo = GetCurrentProcess().WorkingSet64;
         long wirtualneBajtyPo = GetCurrentProcess().VirtualMemorySize64;
         WriteLine("Zakończono nagrywanie.");
         WriteLine($"Wykorzystano {fizyczneBajtyPo - fizyczneBajtyPrzed:N0} fizycznych bajtów.");
         WriteLine($"Wykorzystano {wirtualneBajtyPo - wirtualneBajtyPrzed:N0} wirtualnych bajtów.");
         WriteLine($"Upłynęło {stoper.Elapsed} czasu.");
         WriteLine($"Upłynęło {stoper.ElapsedMilliseconds:N0} milisekund.");
      }
   }
}