﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Security;
using System.Security.Cryptography;
using System.Security.Principal;
using System.Text;
using System.Xml.Linq;

namespace CS7
{
   public static class Ochrona
   {
      // sól musi mieć przynajmniej 8 bajtów, dlatego użyjemy 16.
      private static readonly byte[] sol = Encoding.Unicode.GetBytes("7BANANOW");
      // musimy zrobic przynajmniej 1000 iteracji, dlatego zrobimy 2000
      private static readonly int iteracje = 2000;

      public static string Szyfruj(string jawnyTekst, string haslo)
      {
         byte[] jawneBajty = Encoding.Unicode.GetBytes(jawnyTekst);
         var aes = Aes.Create();
         var pbkdf2 = new Rfc2898DeriveBytes(haslo, sol, iteracje);
         aes.Key = pbkdf2.GetBytes(32); // używamy klucza 256-bitowego
         aes.IV = pbkdf2.GetBytes(16); // wektor inicjujący będzie miał 128 bitów
         var ms = new MemoryStream();
         using (var cs = new CryptoStream(ms, aes.CreateEncryptor(), CryptoStreamMode.Write))
         {
            cs.Write(jawneBajty, 0, jawneBajty.Length);
         }
         return Convert.ToBase64String(ms.ToArray());
      }

      public static string Odszyfruj(string zaszyfrowanyTekst, string haslo)
      {
         byte[] zaszyfrowaneBajty = Convert.FromBase64String(zaszyfrowanyTekst);
         var aes = Aes.Create();
         var pbkdf2 = new Rfc2898DeriveBytes(haslo, sol, iteracje);
         aes.Key = pbkdf2.GetBytes(32);
         aes.IV = pbkdf2.GetBytes(16);
         var ms = new MemoryStream();
         using (var cs = new CryptoStream(ms, aes.CreateDecryptor(), CryptoStreamMode.Write))
         {
            cs.Write(zaszyfrowaneBajty, 0, zaszyfrowaneBajty.Length);
         }
         return Encoding.Unicode.GetString(ms.ToArray());
      }


      private static Dictionary<string, Uzytkownik> Uzytkownicy = new Dictionary<string, Uzytkownik>();      
      public static Uzytkownik Zarejestruj(string nazwaUzytkownika, string haslo, string[] role = null)
      {
         // generowanie losowej soli
         var rng = RandomNumberGenerator.Create();
         var bajtySoli = new byte[16];
         rng.GetBytes(bajtySoli);
         var tekstSoli = Convert.ToBase64String(bajtySoli);
         // generowanie skrótu solonego hasła
         var sha = SHA256.Create();
         var soloneHaslo = haslo + tekstSoli;
         var skrotSolonegoHasla = Convert.ToBase64String(sha.ComputeHash(Encoding.Unicode.GetBytes(soloneHaslo)));
         var uzytkownik = new Uzytkownik
         {
            Nazwisko = nazwaUzytkownika,
            Sol = tekstSoli,
            SkrotSolonegoHasla = skrotSolonegoHasla,
            Role = role
         };
         Uzytkownicy.Add(uzytkownik.Nazwisko, uzytkownik);
         return uzytkownik;
      }

      public static bool SprawdzHaslo(string nazwaUzytkownika, string haslo)
      {
         if (!Uzytkownicy.ContainsKey(nazwaUzytkownika))
         {
            return false;
         }
         var uzytkownik = Uzytkownicy[nazwaUzytkownika];
         // ponowne generowanie skrótu solonego hasła
         var sha = SHA256.Create();
         var soloneHaslo = haslo + uzytkownik.Sol;
         var skrotSolonegoHasla = Convert.ToBase64String(sha.ComputeHash(Encoding.Unicode.GetBytes(soloneHaslo)));
         return (skrotSolonegoHasla == uzytkownik.SkrotSolonegoHasla);
      }

      public static void ZarejestrujTrzechUzytkownikow()
      {
         Zarejestruj("Alicja", "H45lo", new[] { "Administratorzy" });
         Zarejestruj("Bartek", "H45lo", new[] { "Sprzedaz", "Kierownicy" });
         Zarejestruj("Ewa", "H45lo");
      }

      public static void Zaloguj(string nazwaUzytkownika, string haslo)
      {
         if (SprawdzHaslo(nazwaUzytkownika, haslo))
         {
            var tozsamosc = new GenericIdentity(nazwaUzytkownika, "Uwierzytelnianie");
            var uprawnienia = new GenericPrincipal(tozsamosc, Uzytkownicy[nazwaUzytkownika].Role);
            System.Threading.Thread.CurrentPrincipal = uprawnienia;
         }
      }

      public static string KluczPubliczny;
      public static string ZapiszDoXml(this RSA rsa, bool dolaczPrywatneParametry)
      {
         var p = rsa.ExportParameters(dolaczPrywatneParametry);
         XElement xml;
         if (dolaczPrywatneParametry)
         {
            xml = new XElement("KluczRSA"
            , new XElement("Modulo", Convert.ToBase64String(p.Modulus))
            , new XElement("Wykladnik", Convert.ToBase64String(p.Exponent))
            , new XElement("P", Convert.ToBase64String(p.P))
            , new XElement("Q", Convert.ToBase64String(p.Q))
            , new XElement("DP", Convert.ToBase64String(p.DP))
            , new XElement("DQ", Convert.ToBase64String(p.DQ))
            , new XElement("InverseQ", Convert.ToBase64String(p.InverseQ)));
         }
         else
         {
            xml = new XElement("KluczRSA",
               new XElement("Modulo", Convert.ToBase64String(p.Modulus)),
               new XElement("Wykladnik", Convert.ToBase64String(p.Exponent)));
         }
         return xml?.ToString();
      }

      public static void CzytajZXml(this RSA rsa, string parametersAsXml)
      {
         var xml = XDocument.Parse(parametersAsXml);
         var root = xml.Element("KluczRSA");
         var p = new RSAParameters
         {
            Modulus = Convert.FromBase64String(root.Element("Modulo").Value),
            Exponent = Convert.FromBase64String(root.Element("Wykladnik").Value)
         };
         if (root.Element("P") != null)
         {
            p.P = Convert.FromBase64String(root.Element("P").Value);
            p.Q = Convert.FromBase64String(root.Element("Q").Value);
            p.DP = Convert.FromBase64String(root.Element("DP").Value);
            p.DQ = Convert.FromBase64String(root.Element("DQ").Value);
            p.InverseQ = Convert.FromBase64String(root.Element("InverseQ").Value);
         }
         rsa.ImportParameters(p);
      }

      public static string GenerujPodpis(string dane)
      {
         byte[] bajtyDanych = Encoding.Unicode.GetBytes(dane);
         var sha = SHA256.Create();
         var skrotDanych = sha.ComputeHash(bajtyDanych);
         var rsa = RSA.Create();
         KluczPubliczny = rsa.ZapiszDoXml(false); // pobieranie klucza prywatnego
         return Convert.ToBase64String(rsa.SignHash(skrotDanych, HashAlgorithmName.SHA256, RSASignaturePadding.Pkcs1));
      }

      public static bool KontrolaPodpisu(string dane, string podpis)
      {
         byte[] bajtyDanych = Encoding.Unicode.GetBytes(dane);
         var sha = SHA256.Create();
         var skrotDanych = sha.ComputeHash(bajtyDanych);
         byte[] bajtyPodpisu = Convert.FromBase64String(podpis);
         var rsa = RSA.Create();
         rsa.CzytajZXml(KluczPubliczny);
         return rsa.VerifyHash(skrotDanych, bajtyPodpisu, HashAlgorithmName.SHA256, RSASignaturePadding.Pkcs1);
      }


      public static byte[] PobierzLosowyKluczLubWektor(int rozmiar)
      {
         var r = RandomNumberGenerator.Create();
         var dane = new byte[rozmiar];
         r.GetNonZeroBytes(dane); // tablica wypełniona bajtami
                                    // o jakości odpowiedniej dla kryptografii
         return dane;
      }            
   }
}