using Microsoft.AspNetCore.Mvc.RazorPages;
using System.Collections.Generic;
using System.Linq;
using CS7;
using Microsoft.AspNetCore.Mvc;

namespace NorthwindWeb.Pages
{
   public class DostawcyModel : PageModel
   {
      public IEnumerable<string> Dostawcy { get; set; }
      public void OnGet()
      {
         ViewData["Tytul"] = "Witryna WWW firmy Northwind - Dostawcy";
         //Dostawcy = new[] { "Alpha Co", "Beta Limited", "Gamma Corp" };
         
         Dostawcy = db.Suppliers.Select(s => s.CompanyName).ToArray();
         
      }

      private Northwind db;
      public DostawcyModel(Northwind wstrzyknietyKontekst)
      {
         db = wstrzyknietyKontekst;
      }

      [BindProperty]
      public Supplier Dostawca { get; set; }

      public IActionResult OnPost()
      {
         if (ModelState.IsValid)
         {
            db.Suppliers.Add(Dostawca);
            db.SaveChanges();
            return RedirectToPage("/dostawcy");
         }
         return Page();
      }
   }
}