import { Component, Inject } from '@angular/core';
import { Http } from '@angular/http';

@Component({
    selector: 'home',
    templateUrl: './home.component.html'
})

export class HomeComponent {
    public klienci: Klient[];
    constructor(http: Http, @Inject('BASE_URL') baseUrl: string) {
        http.get('http://localhost:5001/api/klienci').subscribe(result => {
            this.klienci = result.json() as Klient[];
        }, error => console.error(error));
    }
}

interface Klient {
    customerID: string;
    companyName: string;
    contactName: string;
    contactTitle: string;
    address: string;
    city: string;
    region: string;
    postalCode: string;
    country: string;
    phone: string;
    fax: string;
}