﻿using System;                     // DateTime
using System.Collections.Generic; // List<T>, HashSet<T>
using System.Xml.Serialization;   // XmlSerializer
using System.IO;                  // FileStream
using CS7;                        // Person
using Newtonsoft.Json;
using static System.Console;
using static System.Environment;
using static System.IO.Path;
using System.Drawing;

namespace PracaZSerializacja
{
   class Program
   {
      static void Main(string[] args)
      {
         OutputEncoding = new System.Text.UTF8Encoding();

         // Tworzenie hierarichii obiektów
         var osoby = new List<Osoba>
         {
            new Osoba(30000M) { Imie = "Alicja", Nazwisko = "Nowak", DataUrodzenia = new DateTime(1974, 3, 14) },
            new Osoba(40000M) { Imie = "Bartosz", Nazwisko = "Kowalski", DataUrodzenia = new DateTime(1969, 11, 23) },
            new Osoba(20000M) { Imie = "Celina", Nazwisko = "Rozenek", DataUrodzenia = new DateTime(1964, 5, 4), Dzieci = new HashSet<Osoba>
            { new Osoba(0M) { Imie = "Anita", Nazwisko = "Rozenek", DataUrodzenia = new DateTime(1990, 7, 12) } } }
         };
         // tworzenie i zapisywanie pliku
         string sciezka = Combine(CurrentDirectory, "osoby.xml");
         FileStream strumien = File.Create(sciezka);
         // tworzenie obiektu, który zapisze listę osób do pliku XML
         var xs = new XmlSerializer(typeof(List<Osoba>));
         // serializowanie hierarchii obiektów do strumienia
         xs.Serialize(strumien, osoby);
         // trzeba zwolnić strumień, żeby zdjąć z pliku blokadę
         strumien.Close();
         WriteLine($"Zapisano {new FileInfo(sciezka).Length} bajtów danych XML do {sciezka}");
         WriteLine();
         // Wyświetlenie zserializowanej hierarchii
         WriteLine(File.ReadAllText(sciezka));

         FileStream odczytaneXml = File.Open(sciezka, FileMode.Open);
         // deserialize and cast the object graph into a List of Person
         var odczytaneOsoby = (List<Osoba>)xs.Deserialize(odczytaneXml);
         foreach (var os in odczytaneOsoby)
         {
            WriteLine($"{os.Nazwisko} ma {os.Dzieci.Count} dzieci.");
         }
         odczytaneXml.Close();



         // tworzenie pliku, do którego będziemy zapisywać
         string sciezkaJson = Combine(CurrentDirectory, "osoby.json");
         StreamWriter strumienJson = File.CreateText(sciezkaJson);
         // Tworzenie obiektu, który będzie zapisywał dane w formacie JSON
         var jss = new JsonSerializer();
         // serializowanie hierarchii obiektów do ciągu znaków
         jss.Serialize(strumienJson, osoby);
         strumienJson.Close(); // zwolnienie blokady pliku
         WriteLine();
         WriteLine($"Zapisano {new FileInfo(sciezkaJson).Length} bajtów danych w formacie JSON do pliku: {sciezkaJson}");
         // Wyświetlenie zserializowanej hierarchii obiektów
         WriteLine(File.ReadAllText(sciezkaJson));

         ReadKey();
      }
   }
}
