﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Logging;
using Microsoft.Extensions.Options;
using Microsoft.EntityFrameworkCore;
using CS7;
using SerwisNorthwind.Repozytoria;
using Swashbuckle.AspNetCore.Swagger;

namespace SerwisNorthwind
{
   public class Startup
   {
      public Startup(IConfiguration configuration)
      {
         Configuration = configuration;
      }

      public IConfiguration Configuration { get; }

      // This method gets called by the runtime. Use this method to add services to the container.
      public void ConfigureServices(IServiceCollection services)
      {
         services.AddCors();

         services.AddDbContext<Northwind>(options => options.UseSqlServer("Server=(localdb)\\mssqllocaldb;Database=Northwind;Trusted_Connection=True;MultipleActiveResultSets = true"));
         services.AddScoped<IRepozytoriumCustomer, RepozytoriumCustomer>();

         // Rejestrowanie generatora Swagger, i definiowanie dokumentacji 
         // dla serwisu Northwind
         services.AddSwaggerGen(c =>
         {
            c.SwaggerDoc("v1", new Info
            {
               Title = "API Serwisu Northwind",
               Version = "v1"
            });
         });

         services.AddMvc();
      }

      // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
      public void Configure(IApplicationBuilder app, IHostingEnvironment env)
      {
         if (env.IsDevelopment())
         {
            app.UseDeveloperExceptionPage();
         }

         app.UseSwagger();
         app.UseSwaggerUI(c =>
         {
            c.SwaggerEndpoint("/swagger/v1/swagger.json",
            "API Serwisu Northwind V1");
         });

         app.UseMvc();
      }
   }
}