﻿using System;
using static System.Console;
using CS7;
using System.Threading;
using System.Security;
using System.Security.Permissions;
using System.Security.Principal;
using System.Security.Claims;

namespace AplikacjaBezpieczna
{
   class Program
   {
      static void Main(string[] args)
      {
         OutputEncoding = new System.Text.UTF8Encoding();

         Ochrona.ZarejestrujTrzechUzytkownikow();
         Write($"Podaj nazwę użytkownika: ");
         string nazwaUzytkownika = ReadLine();
         Write($"Podaj hasło: ");
         string hasło = ReadLine();
         Ochrona.Zaloguj(nazwaUzytkownika, hasło);
         if (Thread.CurrentPrincipal == null)
         {
            WriteLine("Logowanie się nie powiodło.");
            return;
         }
         var p = Thread.CurrentPrincipal;
         WriteLine($"IsAuthenticated: {p.Identity.IsAuthenticated}");
         WriteLine($"AuthenticationType: {p.Identity.AuthenticationType}");
         WriteLine($"Name: {p.Identity.Name}");
         WriteLine($"IsInRole(\"Administratorzy\"): {p.IsInRole("Administratorzy")}");
         WriteLine($"IsInRole(\"Sprzedarz\"): {p.IsInRole("Sprzedaz")}");
         if (p is ClaimsPrincipal)
         {
            WriteLine($"{p.Identity.Name} ma następujące cechy:");
            foreach (Claim cecha in (p as ClaimsPrincipal).Claims)
            {
               WriteLine($" {cecha.Type}: {cecha.Value}");
            }
         }

         try
         {
            FunkcjaWymagaUprawnien();
         }
         catch (System.Exception ex)
         {
            WriteLine($"{ex.GetType()}: {ex.Message}");
         }

         ReadKey();
      }

      static void FunkcjaWymagaUprawnien()
      {
         if (Thread.CurrentPrincipal == null)
         {
            throw new SecurityException("Właściwość Thread.CurrentPrincipal nie może mieć wartości null.");
         }
         if (!Thread.CurrentPrincipal.IsInRole("Administratorzy"))
         {
            throw new SecurityException("Użytkownik musi być członkiem grupy Administratorzy.");
         }
         WriteLine("Masz dostęp do tej zabezpieczonej funkcji.");
      }
   }
}
