﻿using System.IO;
using System.Xml;
using static System.IO.Path;
using static System.Environment;
using static System.Console;
using System;
using System.IO.Compression;

namespace PracaZeStrumieniami
{
   class Program
   {
      // definiuje tablicę z wywołaniami pilotów myśliwców Viper
      static string[] wywolania = new string[] { "Husker", "Starbuck", "Apollo", "Boomer", "Bulldog", "Athena", "Helo", "Racetrack" };

      static void Main(string[] args)
      {
         OutputEncoding = System.Text.Encoding.UTF8;

         //PracaZTekstem();
         PracaZXML();
         PracaZKompresja();

         ReadKey();
      }

      static void PracaZTekstem()
      {
         // definiuje plik, z którym będziemy pracować
         string plikTekstowy = Combine(CurrentDirectory, "strumienie.txt");
         // tworzenie pliku tekstowego zwraca klasę pomocniczą
         StreamWriter tekst = File.CreateText(plikTekstowy);
         // przejdź w pętli wszystkie wywołania i wypisz je 
         // w pliku, każde w osobnym wierszu
         foreach (string wywolanie in wywolania)
         {
            tekst.WriteLine(wywolanie);
         }
         tekst.Close(); // Zwolnij zasoby
                        // wypisz zawartość pliku w konsoli
         WriteLine($"{plikTekstowy} ma wielkość { new FileInfo(plikTekstowy).Length} bajtów.");
         WriteLine(File.ReadAllText(plikTekstowy));
      }

      static void PracaZXML()
      {
         FileStream strumienPlikuXml = null;
         XmlWriter xml = null;
         try
         {
            // definiowanie pliku, do którego będziemy zapisywać
            string plikXml = Combine(CurrentDirectory, "strumienie.xml");
            // utworzenie strumienia do pliku
            strumienPlikuXml = File.Create(plikXml);
            // opakowanie strumienia pliku w obiekt pomocniczy,
            // zapisujący dane XML i automatycznie tworzący wcięcia
            xml = XmlWriter.Create(strumienPlikuXml, new XmlWriterSettings { Indent = true });
            // zapisanie deklaracji XML
            xml.WriteStartDocument();
            // zapisanie elementu bazowego
            xml.WriteStartElement("wywolania");
            // wypisywanie w pętli wszystkich wywołań z tablicy
            foreach (string wywolanie in wywolania)
            {
               xml.WriteElementString("wywolanie", wywolanie);
            }
            // zapisanie zamknięcia elementu bazowego
            xml.WriteEndElement();
            // zamknięcie obiektu pomocniczego i strumienia
            xml.Close();
            strumienPlikuXml.Close();
            // wypisanie zawartosci pliku w koncoli
            WriteLine($"{plikXml} ma wielkość {new FileInfo(plikXml).Length} bajtów.");
            WriteLine(File.ReadAllText(plikXml));
         }
         catch (Exception ex)
         {
            // jeżeli ścieżka nie istnieje, to rzucony wyjątek zostanie tutaj złapany
            WriteLine($"{ex.GetType()} says {ex.Message}");
         }
         finally
         {
            if (xml != null)
            {
               xml.Dispose();
               WriteLine("Niezarządzane zasoby obiektu pomocniczego zostały zwolnione.");
            }
            if (strumienPlikuXml != null)
            {
               strumienPlikuXml.Dispose();
               WriteLine("Niezarządzane zasoby strumienia zostały zwolnione.");
            }
         }
      }

      static void PracaZKompresja()
      {
         // kompresowanie wyjściowych danych XML
         string plikISciezkaGzip = Combine(CurrentDirectory, "strumienie.gzip");
         FileStream plikGzip = File.Create(plikISciezkaGzip);
         using (GZipStream kompresor = new GZipStream(plikGzip, CompressionMode.Compress))
         {
            using (XmlWriter xmlGzip = XmlWriter.Create(kompresor))
            {
               xmlGzip.WriteStartDocument();
               xmlGzip.WriteStartElement("wywołania");
               foreach (string wywolanie in wywolania)
               {
                  xmlGzip.WriteElementString("wywolanie", wywolanie);
               }
            }
         } // zamyka też podstawowy strumień
         // wypisanie zawartości skompresowanego pliku w konsoli
         WriteLine($"{plikISciezkaGzip} ma wielkość {new FileInfo(plikISciezkaGzip).Length} bajtów.");
         WriteLine(File.ReadAllText(plikISciezkaGzip));
         // odczytanie skompresowanego pliku
         WriteLine("Odczytuję skompresowany plik XML:");
         plikGzip = File.Open(plikISciezkaGzip, FileMode.Open);
         using (GZipStream dekompresor = new GZipStream(plikGzip, CompressionMode.Decompress))
         {
            using (XmlReader reader = XmlReader.Create(dekompresor))
            {
               while (reader.Read())
               {
                  // Sprawdzenie, czy aktualnie jesteśmy w węźle o nazwie 'wywolanie'
                  if ((reader.NodeType == XmlNodeType.Element) && (reader.Name == "wywolanie"))
                  {
                     reader.Read(); // przejście do węzła tekstowego w ramach elementu
                     WriteLine($"{reader.Value}"); // odczytanie wartości węzła
                  }
               }
            }
         }
      }

   }
}
