﻿using static System.Console;
using System.IO;
using static System.IO.Directory;
using static System.IO.Path;
using static System.Environment;

namespace PracaZSystemamiPlikow
{
    class Program
    {
        static void Main(string[] args)
        {
            OutputEncoding = System.Text.Encoding.UTF8;

            // WypiszInfoOPliku();
            PracaZNapedami();
            //PracaZKatalogami();
            //PracaZPlikami();

            ReadKey();
        }

        static void WypiszInfoOPliku()
        {
            WriteLine($"Path.PathSeparator: {PathSeparator}");
            WriteLine($"Path.DirectorySeparatorChar: {DirectorySeparatorChar}");
            WriteLine($"Directory.GetCurrentDirectory(): {GetCurrentDirectory()}");
            WriteLine($"Environment.CurrentDirectory: {CurrentDirectory}");
            WriteLine($"Environment.SystemDirectory: {SystemDirectory}");
            WriteLine($"Path.GetTempPath(): {GetTempPath()}");
            WriteLine($"GetFolderPath(SpecialFolder):");
            WriteLine($" System: {GetFolderPath(SpecialFolder.System)}");
            WriteLine($" ApplicationData:{GetFolderPath(SpecialFolder.ApplicationData)}");
            WriteLine($" MojeDokumenty: {GetFolderPath(SpecialFolder.MyDocuments)}");
            WriteLine($" Osobisty: {GetFolderPath(SpecialFolder.Personal)}");
        }

        static void PracaZNapedami()
        {
            WriteLine($"|--------------------------------|------------|---------|--------------------|--------------------|");
            WriteLine($"| Nazwa                          | Typ        | Format  | Wielkość           | Wolne miejsce      |");
            WriteLine($"|--------------------------------|------------|---------|--------------------|--------------------|");
            foreach (DriveInfo naped in DriveInfo.GetDrives())
            {
                if (naped.IsReady)
                {
                    WriteLine($"| {naped.Name,-30} | {naped.DriveType,-10} | {naped.DriveFormat,-7} | {naped.TotalSize,18:N0} | {naped.AvailableFreeSpace,18:N0} |");
                }
                else
                {
                    WriteLine($"| {naped.Name,-30} | {naped.DriveType,-10} |");
                }
            }
            WriteLine($"|--------------------------------|------------|---------|--------------------|--------------------|");
        }

        static void PracaZKatalogami()
        {
            // definiowanie własnej ścieżki
            string folderUzytkownika = GetFolderPath(SpecialFolder.Personal);
            var wlasnyFolder = new string[]
            { folderUzytkownika, "Kod", "Rozdzial09", "NowyFolder" };
            string katalog = Combine(wlasnyFolder);
            WriteLine($"Pracuję w: {katalog}");
            // sprawdzenie, czy katalog istnieje
            WriteLine($"Czy istnieje? {Exists(katalog)}");
            // utworzenie katalogu
            WriteLine("Tworzę katalog...");
            CreateDirectory(katalog);
            WriteLine($"Czy istnieje? {Exists(katalog)}");
            Write("Sprawdź, czy katalog istnieje i naciśnij klawisz ENTER: ");
            ReadLine();
            // usuwanie katalogu
            WriteLine("Usuwam katalog...");
            Delete(katalog, recursive: true);
            WriteLine($"Czy istnieje? {Exists(katalog)}");
        }

        static void PracaZPlikami()
        {
            // definiowanie własnej ścieżki
            string folderUzytkownika = GetFolderPath(SpecialFolder.Personal);
            var wlasnyfolder = new string[]
            { folderUzytkownika, "Kod", "Rozdzial09", "wyjscie" };
            string katalog = Combine(wlasnyfolder);
            CreateDirectory(katalog);
            // definiowanie ścieżki do pliku
            string plikTekstowy = Combine(katalog, "tekst.txt");
            string plikKopiaZapasowa = Combine(katalog, "kopiaZapasowa.bak");
            WriteLine($"Pracuję z: {plikTekstowy}");
            // sprawdzenie, czy plik istnieje
            WriteLine($"Czy plik istnieje? {File.Exists(plikTekstowy)}");
            // utworzenie nowego pliku tekstowego
            // i wpisanie do niego wiersza tekstu
            StreamWriter pisanieTekstu = File.CreateText(plikTekstowy);
            pisanieTekstu.WriteLine("Witaj, C#!");
            pisanieTekstu.Close(); // zamknięcie pliku i zwolnienie zasobów
            WriteLine($"Czy plik istnieje? {File.Exists(plikTekstowy)}");
            // skopiowanie pliku, z nadpisaniem, jeżeli plik już istnieje
            File.Copy(
            sourceFileName: plikTekstowy,
            destFileName: plikKopiaZapasowa,
            overwrite: true);
            WriteLine($"Czy {plikKopiaZapasowa} istnieje? {File.Exists(plikKopiaZapasowa)}");
            Write("Sprawdź, czy plik istnieje, i naciśnij klawisz ENTER: ");
            ReadLine();
            // usunięcie pliku
            File.Delete(plikTekstowy);
            WriteLine($"Czy plik istnieje? {File.Exists(plikTekstowy)}");
            // odczytanie tekstu z pliku kopii zapasowej
            WriteLine($"Czytam zawartość pliku {plikKopiaZapasowa}:");
            StreamReader czytaniPliku = File.OpenText(plikKopiaZapasowa);
            WriteLine(czytaniPliku.ReadToEnd());
            czytaniPliku.Close();

            WriteLine($"Nazwa pliku: {GetFileName(plikTekstowy)}");
            WriteLine($"Nazwa pliku bez rozszerzenia: {GetFileNameWithoutExtension(plikTekstowy)}");
            WriteLine($"Rozszerzenie pliku: {GetExtension(plikTekstowy)}");
            WriteLine($"Losowa nazwa pliku: {GetRandomFileName()}");
            WriteLine($"Nazwa pliku tymczasowego: {GetTempFileName()}");

            var info = new FileInfo(plikKopiaZapasowa);
            WriteLine($"{plikKopiaZapasowa}:");
            WriteLine($"  Ma wielkość {info.Length} bajtów");
            WriteLine($"  Ostatni dostęp: {info.LastAccessTime}");
            WriteLine($"  Parametr tylko-do-odczytu ustawiony jest na {info.IsReadOnly}");
        }
    }
}