﻿using System;
using System.Text;
using static System.Console;

namespace PracaZKodowaniem
{
    class Program
    {
        static void Main(string[] args)
        {
            OutputEncoding = System.Text.Encoding.UTF8;

            WriteLine("Kodowania");
            WriteLine("[1] ASCII");
            WriteLine("[2] UTF-7");
            WriteLine("[3] UTF-8");
            WriteLine("[4] UTF-16 (Unicode)");
            WriteLine("[5] UTF-32");
            WriteLine("[inny klawisz] Domyślne");
            // wybieranie kodowania
            Write("Naciśnij cyfrę, żeby wybrać kodowanie: ");
            ConsoleKey klawisz = ReadKey(false).Key;
            WriteLine();
            WriteLine();
            Encoding enkoder;
            switch (klawisz)
            {
               case ConsoleKey.D1:
                  enkoder = Encoding.ASCII;
                  break;
               case ConsoleKey.D2:
                  enkoder = Encoding.UTF7;
                  break;
               case ConsoleKey.D3:
                  enkoder = Encoding.UTF8;
                  break;
               case ConsoleKey.D4:
                  enkoder = Encoding.Unicode;
                  break;
               case ConsoleKey.D5:
                  enkoder = Encoding.UTF32;
                  break;
               default:
                  enkoder = Encoding.Default;
                  break;
            }
            // definiowanie ciągu znaków do zakodowania
            string komunikat = "Litr mleka kosztuje 1,99 zł";
            // kodowanie ciągu znaków do tablicy bajtów
            byte[] zakodowane = enkoder.GetBytes(komunikat);
            // sprawdzenie ile bajtów wymagało to kodowanie
            WriteLine($"Kodowanie {enkoder.GetType().Name} zajęło {zakodowane.Length} bajtów.");
            // przejrzenie wszystkich bajtów
            WriteLine($"Bajt  Hex  Znak");
            foreach (byte b in zakodowane)
            {
               WriteLine($"{b,4} {b.ToString("X"),4} {(char)b,5}");
            }
            // dekodowanie tablicy bajtów do postaci ciągu znaków i wyświetlenie go
            string odkodowane = enkoder.GetString(zakodowane);
            WriteLine(odkodowane);

         ReadKey();
      }
    }
}
