﻿using System;
using System.Net;
using static System.Console;
using System.Net.NetworkInformation;

namespace PracaZZasobamiSieciowymi
{
    class Program
    {
        static void Main(string[] args)
        {
            Write("Podaj poprawny adres w internecie: ");
            string url = ReadLine();
            if (string.IsNullOrWhiteSpace(url))
            {
                url = "http://world.episerver.com/cms/?q=pagetype";
            }
            var uri = new Uri(url);

            WriteLine($"Protokol: {uri.Scheme}");
            WriteLine($"Port: {uri.Port}");
            WriteLine($"Host: {uri.Host}");
            WriteLine($"Sciezka: {uri.AbsolutePath}");
            WriteLine($"Zapytanie: {uri.Query}");

            IPHostEntry daneHosta = Dns.GetHostEntry(uri.Host);
            WriteLine($"{daneHosta.HostName} ma przypisany taki adres IP:");
            foreach (IPAddress adres in daneHosta.AddressList)
            {
                WriteLine($" {adres}");
            }

            var ping = new Ping();
            PingReply odpowiedz = ping.Send(uri.Host);
            WriteLine($"{uri.Host} na wyslany ping odpowiedzial: {odpowiedz.Status}.");
            if (odpowiedz.Status == IPStatus.Success)
            {
                WriteLine($"Hostowi {odpowiedz.Address} odpowiedz zajela {odpowiedz.RoundtripTime:N0} ms");
            }

            ReadKey();
        }
    }
}