using System;
using System.IO;

class Program
{
  static void Main()
  {
    // Utworzenie w katalogu bieżącym pliku o nazwie test.txt.
    using (Stream s = new FileStream ("test.txt", FileMode.Create))
    {
      Console.WriteLine (s.CanRead);       // true
      Console.WriteLine (s.CanWrite);      // true
      Console.WriteLine (s.CanSeek);       // true

      s.WriteByte (101);
      s.WriteByte (102);
      byte[] block = { 1, 2, 3, 4, 5 }; 
      s.Write (block, 0, block.Length);     // Zapis bloku 5-ciu bajtów.

      Console.WriteLine (s.Length);         // 7
      Console.WriteLine (s.Position);       // 7
      s.Position = 0;                       // Przejście z powrotem na początek.

      Console.WriteLine (s.ReadByte());     // 101
      Console.WriteLine (s.ReadByte());     // 102

      // Odczyt danych ze strumienia i umieszczenie ich w bloku tablicy.
      Console.WriteLine (s.Read (block, 0, block.Length));   // 5

      // Przyjmując założenie, że ostatni odczyt zwrócił wartość 5, więc znajdujemy się
      // się na końcu pliku i dlatego teraz wywołanie Read() zwróci wartość 0.
      Console.WriteLine (s.Read (block, 0, block.Length));   // 0
    }
  }
}