using System;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Threading;

class TcpDemo
{
  static void Main()
  {
    new Thread (Server).Start();       // Współbieżne uruchomienie metody serwera.
    Thread.Sleep (500);                // Serwer otrzymuje nieco czasu na uruchomienie.
    Client();
  }

  static void Client()
  {
    using (TcpClient client = new TcpClient ("localhost", 51111))
    using (NetworkStream n = client.GetStream())
    {
      BinaryWriter w = new BinaryWriter (n);
      w.Write ("Witaj");
      w.Flush();
      Console.WriteLine (new BinaryReader (n).ReadString());
    }
  }

  static void Server()     // Obsługuje pojedyncze żądanie klienta, a następnie kończy działanie.
  {
    TcpListener listener = new TcpListener (IPAddress.Any, 51111);
    listener.Start();
    using (TcpClient c = listener.AcceptTcpClient())
    using (NetworkStream n = c.GetStream())
    {
      string msg = new BinaryReader (n).ReadString();
      BinaryWriter w = new BinaryWriter (n);
      w.Write (msg + " ponownie");
      w.Flush();                      // Konieczne jest wywołanie Flush(), ponieważ
    }                                 // nie pozbywamy się komponentu.
    listener.Stop();
  }
}