public void AssignUsersFullControlToFolder (string path)
{
  try
  {
    var sec = Directory.GetAccessControl (path);
    if (UsersHaveFullControl (sec)) return;

    var rule = new FileSystemAccessRule (
      GetUsersAccount().ToString(),
      FileSystemRights.FullControl,
      InheritanceFlags.ContainerInherit | InheritanceFlags.ObjectInherit,
      PropagationFlags.None,
      AccessControlType.Allow);

      sec.AddAccessRule (rule);
      Directory.SetAccessControl (path, sec);
  }
  catch (UnauthorizedAccessException)
  {
    // Katalog został już utworzony przez innego użytkownika.
  }
}

bool UsersHaveFullControl (FileSystemSecurity sec)
{
  var usersAccount = GetUsersAccount();
  var rules = sec.GetAccessRules (true, true, typeof (NTAccount))
                 .OfType<FileSystemAccessRule>();

  return rules.Any (r =>
    r.FileSystemRights == FileSystemRights.FullControl &&
    r.AccessControlType == AccessControlType.Allow && 
    r.InheritanceFlags == (InheritanceFlags.ContainerInherit | 
                           InheritanceFlags.ObjectInherit) &&
    r.IdentityReference == usersAccount);
}

NTAccount GetUsersAccount()
{
  var sid = new SecurityIdentifier (WellKnownSidType.BuiltinUsersSid, null);
  return (NTAccount)sid.Translate (typeof (NTAccount));
}