PerformanceCounterCategory[] cats =
  PerformanceCounterCategory.GetCategories();

foreach (PerformanceCounterCategory cat in cats)
{
  Console.WriteLine ("Kategoria: " + cat.CategoryName);

  string[] instances = cat.GetInstanceNames();
  if (instances.Length == 0)
  {
    foreach (PerformanceCounter ctr in cat.GetCounters())
      Console.WriteLine ("  Licznik: " + ctr.CounterName);
  }
  else   // Liczniki wraz z egzemplarzami.   
  {
    foreach (string instance in instances)
    {
      Console.WriteLine ("  Egzemplarz: " + instance);
      if (cat.InstanceExists (instance))
        foreach (PerformanceCounter ctr in cat.GetCounters (instance))
          Console.WriteLine ("    Licznik: " + ctr.CounterName);
    }
  }
}