﻿using System.ComponentModel.DataAnnotations.Schema;  // [Column]

namespace Biblioteka.ModeleEncji;

public class Category
{
   // te właściwości odwzorowują kolumny w bazie danych
   public int CategoryID { get; set; }

   public string? CategoryName { get; set; } = null!;

   [Column(TypeName = "ntext")]
   public string? Description { get; set; }

   // definiuje właściwość nawigacyjną dla powiązanych wierszy
   public virtual ICollection<Product> Products { get; set; }
      // aby programiści mogli dodawać produkty do kategorii,
      // musimy zainicjować właściwość nawigacyjną za pomocą
      // pustej kolekcji. Pozwala to też uniknąć rzucenia wyjątku
      // przy korzystaniu z takiego elementu jak Count.
      = new HashSet<Product>();
}
