using Northwind.MinimalApi;
using System.Text.Json.Serialization;

var builder = WebApplication.CreateSlimBuilder(args);

builder.Services.ConfigureHttpJsonOptions(opcje =>
{
  opcje.SerializerOptions.TypeInfoResolverChain.Insert(0, AppJsonSerializerContext.Default);
});

var app = builder.Build();

var prosteDoZrobienia = GeneratorDoZrobienia.Wygeneruj().ToArray();

var apiDoZrobienia = app.MapGroup("/dozrobienia");
apiDoZrobienia.MapGet("/", () => prosteDoZrobienia);
apiDoZrobienia.MapGet("/{id}", (int id) =>
    prosteDoZrobienia.FirstOrDefault(a => a.Id == id) is { } doZrobienia
        ? Results.Ok(doZrobienia)
        : Results.NotFound());

app.Run();

[JsonSerializable(typeof(DoZrobienia[]))]
internal partial class AppJsonSerializerContext : JsonSerializerContext
{

}
