﻿using System.Numerics; 

#region Praca z wielkimi liczbami całkowitymi

const int szerokosc = 40;

WriteLine("Porównanie wartości ulong.MaxValue oraz 30-cyfrowej liczby BigInteger");
WriteLine(new string('-', szerokosc));

ulong wielka = ulong.MaxValue;
WriteLine($"{wielka,szerokosc:N0}");

BigInteger wieksza =
  BigInteger.Parse("123456789012345678901234567890");
WriteLine($"{wieksza,szerokosc:N0}");

#endregion

#region Praca z liczbami zespolonymi

Complex z1 = new(real: 4, imaginary: 2);
Complex z2 = new(real: 3, imaginary: 7);
Complex z3 = z1 + z2;

// Wypisanie wartości za pomocą domyślnej implementacji ToString.
WriteLine($"{z1} dodana do {z2} daje {z3}");

// Wypisanie wartości za pomocą własnego formatu.
WriteLine("{0} + {1}i dodana do {2} + {3}i daje {4} + {5}i",
  z1.Real, z1.Imaginary,
  z2.Real, z2.Imaginary,
  z3.Real, z3.Imaginary);

#endregion

#region Generowanie liczb losowych na potrzeby gier i innych aplikacji

Random r = Random.Shared;

// minValue należy do losowanego zakresu liczb, to znaczy 1 może zostać wylosowane.
// maxValue nie należy do losowanego zakresu liczb, to znaczy 7 nie może zostać wylosowane.
int rzutKostka = r.Next(minValue: 1, maxValue: 7); // Zwraca liczby od 1 do 6.
WriteLine($"Losowy rzut kostką: {rzutKostka}");

double losowaRzeczywista = r.NextDouble(); // Zwraca wartości od 0.0 do mniejszej niż 1.0.
WriteLine($"Losowa liczba rzeczywista: {losowaRzeczywista}");

byte[] tablicaBajtow = new byte[256];
r.NextBytes(tablicaBajtow); // Wypełnia tablicę 256 losowymi bajtami.

Write("Losowe bajty: ");
for (int i = 0; i < tablicaBajtow.Length; i++)
{
   Write($"{tablicaBajtow[i]:X2} ");
}
WriteLine();

string[] beatles = r.GetItems(
  choices: new[] { "John", "Paul", "George", "Ringo" },
  length: 10);

Write("Dziesięciu losowych beatelsów:");
foreach (string beatle in beatles)
{
   Write($" {beatle}");
}
WriteLine();

r.Shuffle(beatles);

Write("Pomieszani beatlesi:");
foreach (string beatle in beatles)
{
   Write($" {beatle}");
}
WriteLine();

#endregion

#region Generowanie GUID

WriteLine($"Pusty GUID: {Guid.Empty}.");
Guid g = Guid.NewGuid();
WriteLine($"Losowy GUID: {g}.");

byte[] guidAsBytes = g.ToByteArray();
Write("GUID jako tablica bajtó: ");
for (int i = 0; i < guidAsBytes.Length; i++)
{
   Write($"{guidAsBytes[i]:X2} ");
}
WriteLine();

#endregion
