﻿using Biblioteka;

int nieMozeBycNull = 4;
//nieMozeBycNull = null; // błąd kompilacji!
WriteLine(nieMozeBycNull);

int? mozeBycNull = null;
WriteLine(mozeBycNull);
WriteLine(mozeBycNull.GetValueOrDefault());

mozeBycNull = 7;
WriteLine(mozeBycNull);
WriteLine(mozeBycNull.GetValueOrDefault());

// Typ int? jest aliastem typu Nullable<int>.
Nullable<int> rowniezMozeBycNull = null;
rowniezMozeBycNull = 9;
WriteLine(rowniezMozeBycNull);

string imie;      // Pozwala na wartości null, ale generuje ostrzeżenia.
string? nazwisko; // Pozwala na wartości null i nie generuje ostrzeżeń.

// Deklarowanie nienullowalnych zmiennych i parametrów
Adres adres = new(miasto: "Wrocław")
{
   Budynek = null,
   Ulica = null!,
   Region = "PL"
};

WriteLine(adres.Budynek?.Length);

if (adres.Ulica is not null)
{
   WriteLine(adres.Ulica.Length);
}
