namespace Biblioteka
{
  public partial class Osoba
  {
    // a property defined using C# 1 - 5 syntax 
    public string Pochodzenie
    {
      get
      {
        return $"{Nazwisko} pochodzi z planety {Planeta}";
      }
    }

    // dwie właściwości zdefiniowane przy użyciu wyrażeń lambda z C# 6+
    public string Pozdrowienie => $"{Nazwisko} mówi 'Cześć!'";

    public int Wiek => System.DateTime.Today.Year - DataUrodzenia.Year;

    public string? UlubioneLody { get; set; } // składnia automatyczna

    private string? ulubionyKolorPodstawowy;
    public string? UlubionyKolorPodstawowy
    {
      get
      {
        return ulubionyKolorPodstawowy;
      }
      set
      {
        switch (value?.ToLower())
        {
          case "czerwony":
          case "zielony":
          case "niebieski":
            ulubionyKolorPodstawowy = value;
            break;
          default:
            throw new System.ArgumentException(
              $"{value} nie jest kolorem podstawowym." +
              $"Wybieraj spośród wartości: czerwony, zielony, niebieski.");
        }
      }
    }

    // indeksery
    public Osoba this[int index]
    {
      get
      {
        return Dzieci[index];
      }
      set
      {
        Dzieci[index] = value;
      }
    }
  }
}