﻿using System.Text;

WriteLine("Kodowania");
WriteLine("[1] ASCII");
WriteLine("[2] UTF-7");
WriteLine("[3] UTF-8");
WriteLine("[4] UTF-16 (Unicode)");
WriteLine("[5] UTF-32");
WriteLine("[6] Latin1");
WriteLine("[inny klawisz] Domyślne");
WriteLine();

// wybieranie kodowania
Write("Naciśnij cyfrę, żeby wybrać kodowanie: ");
ConsoleKey klawisz = ReadKey(intercept: true).Key;
WriteLine(); WriteLine();

Encoding enkoder = klawisz switch
{
   ConsoleKey.D1 or ConsoleKey.NumPad1 => Encoding.ASCII,
   ConsoleKey.D2 or ConsoleKey.NumPad2 => Encoding.UTF7,
   ConsoleKey.D3 or ConsoleKey.NumPad3 => Encoding.UTF8,
   ConsoleKey.D4 or ConsoleKey.NumPad4 => Encoding.Unicode,
   ConsoleKey.D5 or ConsoleKey.NumPad5 => Encoding.UTF32,
   ConsoleKey.D6 or ConsoleKey.NumPad6 => Encoding.Latin1,
   _ => Encoding.Default
};

// definiowanie ciągu znaków do zakodowania
string komunikat = "Kawa kosztuje 4,39 zł";
WriteLine($"Tekst do zakodowania: {komunikat}   Długość: { komunikat.Length}");

// kodowanie ciągu znaków do tablicy bajtów
byte[] zakodowane = enkoder.GetBytes(komunikat);

// sprawdzenie, ile bajtów wymagało to kodowanie
WriteLine("Kodowanie {0} zajęło {1:N0} bajtów.", 
   arg0: enkoder.GetType().Name, arg1: zakodowane.Length);
WriteLine();

// przejrzenie wszystkich bajtów
WriteLine($"Bajt | Hex | Znak");
foreach (byte b in zakodowane)
{
   WriteLine($"{b,4} |{b,3:X} | {(char)b,4}");
}

// dekodowanie tablicy bajtów do postaci ciągu znaków i wyświetlenie go
string odkodowane = enkoder.GetString(zakodowane);
WriteLine(odkodowane);
