﻿using Microsoft.EntityFrameworkCore; // To use UseSqlite.
using Microsoft.Extensions.DependencyInjection; // To use IServiceCollection.

namespace Northwind.ModeleEncji;

public static class RozszerzeniaKontekstuNorthwind
{
  /// <summary>
  /// Dodaje KontekstNorthwind do wskazanej kolekcji IServiceCollection. 
  /// Używa dostawcy bazy danych Sqlite.
  /// </summary>
  /// <param name="uslugi">Kolekcja usług.</param>
  /// <param name="sciezkaWzgledna">Domyślna ścieżka to ".."</param>
  /// <param name="nazwaBazyDanych">Domyślna nazwa to "Northwind.db"</param>
  /// <returns>Kolekcję IServiceCollection, do której można dodawać kolejne usługi.</returns>
  public static IServiceCollection DodajKontekstNorthwind(
    this IServiceCollection uslugi, 
    string sciezkaWzgledna = "..",
    string nazwaBazyDanych = "Northwind.db")
  {
    string sciezka = Path.Combine(sciezkaWzgledna, nazwaBazyDanych);
    sciezka = Path.GetFullPath(sciezka);
    ProtokolKontekstuNorthwind.WriteLine($"Ścieżka bazy danych: {sciezka}");

    if (!File.Exists(sciezka))
    {
      throw new FileNotFoundException(
        message: $"Nie znaleziono {sciezka}.", fileName: sciezka);
    }

    uslugi.AddDbContext<KontekstNorthwind>(opcje =>
    {
      // Dzisiaj zamiast parametru Filename używa się parametru Data Source.
      opcje.UseSqlite($"Data Source={sciezka}");

      opcje.LogTo(ProtokolKontekstuNorthwind.WriteLine,
        new[] { Microsoft.EntityFrameworkCore
          .Diagnostics.RelationalEventId.CommandExecuting });
    },
    // Rejestrujemy z czasem życia Transient, aby uniknąć
    // problemów ze współbieżnością w projektach serwerowych Blazor.
    contextLifetime: ServiceLifetime.Transient,
    optionsLifetime: ServiceLifetime.Transient);

    return uslugi;
  }
}
