using Northwind.Blazor.Components;
using Northwind.Blazor.Services; // ISerwisNorthwind.

var builder = WebApplication.CreateBuilder(args);

// Dodaj serwisy do kontekenra.
builder.Services.AddRazorComponents()
  .AddInteractiveServerComponents()
  .AddInteractiveWebAssemblyComponents();

builder.Services.DodajKontekstNorthwind();

builder.Services.AddTransient<ISerwisNorthwind,
  SerwerowySerwisNorthwind>();

var app = builder.Build();

// Konfigurowanie potoku obsługi żądań HTTP.
if (!app.Environment.IsDevelopment())
{
  app.UseExceptionHandler("/Blad", createScopeForErrors: true);  
  app.UseHsts();
}

app.UseHttpsRedirection();

app.UseStaticFiles();
app.UseAntiforgery();

app.MapRazorComponents<App>()
  .AddInteractiveServerRenderMode()
  .AddInteractiveWebAssemblyRenderMode()
  .AddAdditionalAssemblies(typeof(Northwind.Blazor.Wasm._Imports).Assembly);

app.Run();
