using System.Globalization;

partial class Program
{
   private static void KonfigurujKonsole(string kultura = "pl-PL",
    bool uzyjKulturyKomputera = false)
   {        
      OutputEncoding = System.Text.Encoding.UTF8;

      if (!uzyjKulturyKomputera)
      {
         CultureInfo.CurrentCulture = CultureInfo.GetCultureInfo(kultura);
      }
      WriteLine($"Aktualana kultura: {CultureInfo.CurrentCulture.DisplayName}");
   }

   static void TytulSekcji(string tytul)
  {
    ConsoleColor poprzedniKolor = ForegroundColor;
    ForegroundColor = ConsoleColor.DarkYellow;
    WriteLine("*");
    WriteLine($"* {tytul}");
    WriteLine("*");
    ForegroundColor = poprzedniKolor;
  }
}
