﻿partial class Program
{
  static void Wypisz<T>(string tytul, IEnumerable<T> kolekcja)
  {
     WriteLine(tytul);
     foreach (T element in kolekcja)
     {
        WriteLine($"  {element}");
     }
  }
  
  static void WypiszKolejkePriorytetowa<TElement, TPriorytet>(string tytul,
    IEnumerable<(TElement Element, TPriorytet Priorytet)> kolekcja)
  {
    WriteLine(tytul);
    foreach ((TElement, TPriorytet) element in kolekcja)
    {
      WriteLine($" {element.Item1}: {element.Item2}");
    }
  }

   private static void UzyjSlownika(
      IDictionary<string, string> slownik)
   {
      // Wykonaj ze słownikiem pracę, która wymaga tylko dostępu do odczytu.
      WriteLine($"Początkowo: {slownik.Count}.");
      try
      {
         WriteLine("Dodaję nowy element z wartościami GUID.");
         // Metoda Add nie zwraca żadnej wartości.
         slownik.Add(
           key: Guid.NewGuid().ToString(),
           value: Guid.NewGuid().ToString());
      }
      catch (NotSupportedException)
      {
         WriteLine("Ten słownik nie udostępnia metody Add.");
      }
      WriteLine($"Na koniec: {slownik.Count}.");
   }
}

