﻿using System.Diagnostics;
using Microsoft.Extensions.Configuration;

string sciezkaProtokolu = Path.Combine(Environment.GetFolderPath(
    Environment.SpecialFolder.DesktopDirectory), "protokol.txt");

Console.WriteLine($"Zapisuję do: {sciezkaProtokolu}");

TextWriterTraceListener plikProtokolu = new(File.CreateText(sciezkaProtokolu));

Trace.Listeners.Add(plikProtokolu);

#if DEBUG
// Zapisywanie tekstu jest buforowane, a ta opcja wywołuje
// metodę Flush() we wszystkich obiektach nasłuchujących
// po wykonaniu każdego zapisu.
Trace.AutoFlush = true;
#endif


Debug.WriteLine("Typ Debug mówi, że już jest gotowy!");
Trace.WriteLine("Typ Trace mówi, że już jest gotowy!");


string plikUstawien = "appsettings.json";
string sciezkaUstawien = Path.Combine(
  Directory.GetCurrentDirectory(), plikUstawien);

Console.WriteLine("Przetwarzam: {0}", sciezkaUstawien);

Console.WriteLine("--{0}: zawartość--", plikUstawien);
Console.WriteLine(File.ReadAllText(sciezkaUstawien));
Console.WriteLine("----");

ConfigurationBuilder tworcaKonfiguracji = new();

tworcaKonfiguracji.SetBasePath(Directory.GetCurrentDirectory());

// Dodaj plik ustawien do aktualnej konfiguracj i traktuj go jak
// element obowiązkowy. W efekcie, jeżeli aplikacja nie znajdzie tego
// pliku, to rzuci wyjątek.
tworcaKonfiguracji.AddJsonFile(plikUstawien,
    optional: true, reloadOnChange: true);

IConfigurationRoot konfiguracja = tworcaKonfiguracji.Build();

TraceSwitch ts = new(
  displayName: "Przelacznik",
  description: "Ten przełącznik jest ustawiany przez konfigurację z pliku JSON.");

konfiguracja.GetSection("Przelacznik").Bind(ts);

Console.WriteLine($"Przełącznik, właściwość Value: {ts.Value}");
Console.WriteLine($"Przełącznik, właściwość Level: {ts.Level}");

Trace.WriteLineIf(ts.TraceError, "Poziom błędów");
Trace.WriteLineIf(ts.TraceWarning, "Poziom ostrzeżeń");
Trace.WriteLineIf(ts.TraceInfo, "Poziom informacji");
Trace.WriteLineIf(ts.TraceVerbose, "Poziom ogólny");

// Zamknij plik tekstowy (z opróżnieniem bufora) i zwolnij zasoby.
Debug.Close();
Trace.Close();

Console.WriteLine("Naciśnij Enter aby zamknąć program.");
Console.ReadLine();
