﻿using static System.Convert;
using System.Globalization;

#region Jawne i niejawne rzutowanie liczb

int a = 10;
double b = a; // Liczbę typu int można zapisać w zmiennej typu double.
WriteLine($"a to {a}, b to {b}");

double c = 9.8;
int d = (int)c;  // Kompilator zgłosi błąd bez jawnego rzutowania.
WriteLine($"c to {c}, d to {d}"); // W zmiennej d zabraknie ułamka .8.

long e = 5_000_000_000;
int f = (int)e;
WriteLine($"e to {e:N0}, f to {f:N0}");

e = long.MaxValue;
f = (int)e;
WriteLine($"e to {e:N0}, f to {f:N0}");

#endregion

#region Binarna reprezentacja liczba ujemnych

WriteLine("{0,12} {1,34}", "Dziesiętnie", "Binarnie");
WriteLine("{0,12} {0,34:B32}", int.MaxValue);
for (int i = 8; i >= -8; i--)
{
   WriteLine("{0,12} {0,34:B32}", i);
}
WriteLine("{0,12} {0,34:B32}", int.MinValue);

#endregion

#region Konwertowanie za pomocą typu System.Convert

double g = 9.8;
int h = ToInt32(g); // Metoda typu System.Convert.
WriteLine($"g to {g}, h to {h}");

#endregion

#region Zaokrąglanie liczba i domyślne reguły zaokrąglania

double[,] liczby = {
  { 9.49, 9.5, 9.51 },
  { 10.49, 10.5, 10.51 },
  { 11.49, 11.5, 11.51 },
  { 12.49, 12.5, 12.51 },
  { -12.49, -12.5, -12.51 },
  { -11.49, -11.5, -11.51 },
  { -10.49, -10.5, -10.51 },
  { -9.49, -9.5, -9.51 }
};

WriteLine($"| double | ToInt32 | double | ToInt32 | double | ToInt32 |");
for (int x = 0; x < 8; x++)
{
   for (int y = 0; y < 3; y++)
   {
      Write($"| {liczby[x, y],6} | {ToInt32(liczby[x, y]),7} ");
   }
   WriteLine("|");
}
WriteLine();

#endregion

#region Sterowanie regułami zaokrąglania

foreach (double n in liczby)
{
   WriteLine(format:
     "Math.Round({0}, 0, MidpointRounding.AwayFromZero) to {1}",
     arg0: n,
     arg1: Math.Round(value: n, digits: 0,
             mode: MidpointRounding.AwayFromZero));
}

#endregion

#region Konwersja z dowolnego typu na ciąg znaków

int liczba = 12;
WriteLine(liczba.ToString());
bool logiczna = true;
WriteLine(logiczna.ToString());
DateTime teraz = DateTime.Now;
WriteLine(teraz.ToString());
object ja = new();
WriteLine(ja.ToString());

#endregion

#region Konwersja z obiektu binarnego na ciąg znaków

// Przygotowanie tablicy 128 bajtów.
byte[] obiektBinarny = new byte[128];

// Wpełnienie tablicy losowymi bajtami.
Random.Shared.NextBytes(obiektBinarny);

WriteLine("Obiekt binarny jako bajty:");
for (int indeks = 0; indeks < obiektBinarny.Length; indeks++)
{
   Write($"{obiektBinarny[indeks]:X2} ");
}
WriteLine();

// Konwersja tablicy do ciągu znaków Base64 i wypisanie go.
string zakodowane = ToBase64String(obiektBinarny);
WriteLine($"Obiekt binarny jako Base64: {zakodowane}");

#endregion

#region Parsowanie ciągu znaków do postaci liczb, dat lub czasu

// Ustalenie aktualnej kultury, aby mieć pewność, że parsowanie zadziała poprawnie.
CultureInfo.CurrentCulture = CultureInfo.GetCultureInfo("pl-PL");

int przyjaciele = int.Parse("27");
DateTime urodziny = DateTime.Parse("4 czerwiec 1980");
WriteLine($"Muszę zaprosić {przyjaciele} przyjaciół na moje urodziny.");
WriteLine($"Moje urodziny są {urodziny}.");
WriteLine($"Moje urodziny są {urodziny:D}.");

#endregion

#region Unikanie wyjątków przy parsowaniu za pomocą metody TryParse 

Write("Ile mamy tu jajek? ");
string? dane = ReadLine();

if (int.TryParse(dane, out int liczbaJajek))
{
   WriteLine($"Mamy {liczbaJajek} jajek.");
}
else
{
   WriteLine("Nie udało się parsować danych.");
}

#endregion

