namespace Northwind.MinimalApi
{
  public class DoZrobienia
  {
    public int Id { get; set; }

    public string? Tytul { get; set; }

    public DateOnly? Termin { get; set; }

    public bool Zrobione { get; set; }
  }

  internal static class GeneratorDoZrobienia
  {
    private static readonly (string[] Prefiksy, string[] Sufiksy)[] _elementy = new[]
        {
            (new[] { "Wyprowadź", "Nakarm" }, new[] { "psa", "kota", "kozę" }),
            (new[] { "Zrób", "Odłóż" }, new[] { "zakupy", "pranie", "obiad" }),
            (new[] { "Wyczyść" }, new[] { "łazienkę", "basen", "zasłony", "auto" })
        };

    internal static IEnumerable<DoZrobienia> Wygeneruj(int liczba = 5)
    {
      var liczbaElementow = _elementy.Sum(row => row.Prefiksy.Length * row.Sufiksy.Length);
      var mapaElementow = new (int Row, int Prefix, int Suffix)[liczbaElementow];
      var numerElementu = 0;
      for (var i = 0; i < _elementy.Length; i++)
      {
        var prefiksy = _elementy[i].Prefiksy;
        var sufiksy = _elementy[i].Sufiksy;
        for (var j = 0; j < prefiksy.Length; j++)
        {
          for (var k = 0; k < sufiksy.Length; k++)
          {
            mapaElementow[numerElementu++] = (i, j, k);
          }
        }
      }

      Random.Shared.Shuffle(mapaElementow);

      for (var id = 1; id <= liczba; id++)
      {
        var (indeksWiersza, indeksPrefiksu, indeksSufiksu) = mapaElementow[id];
        var (prefiksy, sufiksy) = _elementy[indeksWiersza];
        yield return new DoZrobienia
        {
          Id = id,
          Tytul = string.Join(' ', prefiksy[indeksPrefiksu], sufiksy[indeksSufiksu]),
          Termin = Random.Shared.Next(-200, 365) switch
          {
            < 0 => null,
            var dni => DateOnly.FromDateTime(DateTime.Now.AddDays(dni))
          }
        };
      }
    }
  }
}