﻿using Microsoft.EntityFrameworkCore; // DbContext, DbContextOptionsBuilder
// Pozwala użyć metody RelationalEventId.
using Microsoft.EntityFrameworkCore.Diagnostics;


namespace Biblioteka.ModeleEncji;

// zajmuje się obsługą połączenia z bazą danych
public class Northwind : DbContext
{
   // te właściwości odwzorowują tabele z bazy danych
   public DbSet<Category> Categories { get; set; }
   public DbSet<Product> Products { get; set; }


   protected override void OnConfiguring(
     DbContextOptionsBuilder optionsBuilder)
   {
      optionsBuilder.UseLazyLoadingProxies();

      string plikBazyDanych = "Northwind.db";
      string sciezka = Path.Combine(
        Environment.CurrentDirectory, plikBazyDanych);

      string polaczenie = $"Data Source={sciezka}";
      WriteLine($"Połączenie: {polaczenie}");
      optionsBuilder.UseSqlite(polaczenie);

      optionsBuilder.LogTo(WriteLine,  // Metoda klasy Console.
         new[] { RelationalEventId.CommandExecuting })
#if DEBUG
  .EnableSensitiveDataLogging() // Wypisywanie parametrów SQL.
  .EnableDetailedErrors()
#endif
;
   }

   protected override void OnModelCreating(
   ModelBuilder modelBuilder)
   {
      // przykład użycia płynnego API zamiast atrybutów,
      // aby ograniczyć długość nazwy kategorii do 40 znaków
      modelBuilder.Entity<Category>()
         .Property(category => category.CategoryName)
         .IsRequired()  // NOT NULL
         .HasMaxLength(15);
      if (Database.ProviderName?.Contains("SQLite") ?? false)
      {
         // dodane w celu "naprawienia" braku typu decimal w SQLite
         modelBuilder.Entity<Product>()
            .Property(product => product.Koszt)
            .HasConversion<double>();
      }
      // globalny filtr usuwający produkty nieprodukowane
      modelBuilder.Entity<Product>()
         .HasQueryFilter(p => !p.Discontinued);

   }
}
