using Microsoft.AspNetCore.Mvc.RazorPages; // PageModel.
using Northwind.ModeleEncji; // KOntekstNorthwind.
using Microsoft.AspNetCore.Mvc; // [BindProperty], IActionResult.

namespace Northwind.Web.Pages;

public class DostawcyModel : PageModel
{
  private KontekstNorthwind _db;

  public DostawcyModel(KontekstNorthwind db)
  {
    _db = db;

    // Inicjowanie właścowsci Supplier, aby uniknąć ostreżeń o wartości null w widoku.
    //Supplier = new();
  }

  public IEnumerable<Supplier>? Dostawcy { get; set; }

  public void OnGet()
  {
    ViewData["Tytul"] = "Northwind - Dostawcy";

    Dostawcy = _db.Suppliers
      .OrderBy(c => c.Country)
      .ThenBy(c => c.CompanyName);
  }

  [BindProperty]
  public Supplier Dostawca { get; set; }

  public IActionResult OnPost()
  {
    if (Dostawca is not null && ModelState.IsValid)
    {
      _db.Suppliers.Add(Dostawca);
      _db.SaveChanges();
      return RedirectToPage("/dostawcy");
    }
    else
    {
      return Page(); // Powrót do strony wejściowej.
    }
  }
}
