﻿using System;
using System.Collections.Generic;
using Microsoft.EntityFrameworkCore;
using Microsoft.Data.SqlClient; // SqlConnectionStringBuilder.

namespace Northwind.ModeleEncji;

public partial class KontekstNorthwind : DbContext
{
    public KontekstNorthwind()
    {
    }

    public KontekstNorthwind(DbContextOptions<KontekstNorthwind> opcje)
        : base(opcje)
    {
    }

    public virtual DbSet<AlfabetycznaListaProduktow> AlphabeticalListOfProducts { get; set; }

    public virtual DbSet<Category> Categories { get; set; }

    public virtual DbSet<SprzedazKategoriiZaRok1997> CategorySalesFor1997s { get; set; }

    public virtual DbSet<CurrentProductList> CurrentProductLists { get; set; }

    public virtual DbSet<Customer> Customers { get; set; }

    public virtual DbSet<CustomerAndSuppliersByCity> CustomerAndSuppliersByCities { get; set; }

    public virtual DbSet<CustomerDemographic> CustomerDemographics { get; set; }

    public virtual DbSet<Employee> Employees { get; set; }

    public virtual DbSet<Invoice> Invoices { get; set; }

    public virtual DbSet<Order> Orders { get; set; }

    public virtual DbSet<OrderDetail> OrderDetails { get; set; }

    public virtual DbSet<OrderDetailsExtended> OrderDetailsExtendeds { get; set; }

    public virtual DbSet<OrderSubtotal> OrderSubtotals { get; set; }

    public virtual DbSet<OrdersQry> OrdersQries { get; set; }

    public virtual DbSet<Product> Products { get; set; }

    public virtual DbSet<ProductSalesFor1997> ProductSalesFor1997s { get; set; }

    public virtual DbSet<ProductsAboveAveragePrice> ProductsAboveAveragePrices { get; set; }

    public virtual DbSet<ProductsByCategory> ProductsByCategories { get; set; }

    public virtual DbSet<QuarterlyOrder> QuarterlyOrders { get; set; }

    public virtual DbSet<Region> Regions { get; set; }

    public virtual DbSet<SalesByCategory> SalesByCategories { get; set; }

    public virtual DbSet<SalesTotalsByAmount> SalesTotalsByAmounts { get; set; }

    public virtual DbSet<Shipper> Shippers { get; set; }

    public virtual DbSet<SummaryOfSalesByQuarter> SummaryOfSalesByQuarters { get; set; }

    public virtual DbSet<SummaryOfSalesByYear> SummaryOfSalesByYears { get; set; }

    public virtual DbSet<Supplier> Suppliers { get; set; }

    public virtual DbSet<Territory> Territories { get; set; }

    protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
  {
    if (!optionsBuilder.IsConfigured)
    {
      SqlConnectionStringBuilder konfigurator = new();

      konfigurator.DataSource = "."; // "NazwaSerwera\NazwaInstancji" np. @".\sqlexpress"
      konfigurator.InitialCatalog = "Northwind";
      konfigurator.TrustServerCertificate = true;
      konfigurator.MultipleActiveResultSets = true;

      // Chcemy szybciej wywołać błąd. Domyślnie to 15 sekund.
      konfigurator.ConnectTimeout = 3;

      // Jezeli używamy uwierzytelniania Windows .
      konfigurator.IntegratedSecurity = true;

      // Jeżeli używamy uwierzytelniania SQL Server.
      // konfigurator.UserID = Environment.GetEnvironmentVariable("MY_SQL_USR");
      // konfigurator.Password = Environment.GetEnvironmentVariable("MY_SQL_PWD");

      optionsBuilder.UseSqlServer(konfigurator.ConnectionString);

      optionsBuilder.LogTo(ProtokolKontekstuNorthwind.WriteLine,
        new[] { Microsoft.EntityFrameworkCore
          .Diagnostics.RelationalEventId.CommandExecuting });
    }
  }

  protected override void OnModelCreating(ModelBuilder modelBuilder)
    {
        modelBuilder.Entity<AlfabetycznaListaProduktow>(encja =>
        {
            encja.ToView("Alfabetyczna lista produktów");
        });

        modelBuilder.Entity<SprzedazKategoriiZaRok1997>(encja =>
        {
            encja.ToView("Kategoria sprzedarzy w roku 1997");
        });

        modelBuilder.Entity<CurrentProductList>(encja =>
        {
            encja.ToView("Aktualna lista produktów");

            encja.Property(e => e.ProductId).ValueGeneratedOnAdd();
        });

        modelBuilder.Entity<Customer>(encja =>
        {
            encja.Property(e => e.CustomerId).IsFixedLength();

            encja.HasMany(d => d.CustomerTypes).WithMany(p => p.Customers)
                .UsingEntity<Dictionary<string, object>>(
                    "CustomerCustomerDemo",
                    r => r.HasOne<CustomerDemographic>().WithMany()
                        .HasForeignKey("CustomerTypeId")
                        .OnDelete(DeleteBehavior.ClientSetNull)
                        .HasConstraintName("FK_CustomerCustomerDemo"),
                    l => l.HasOne<Customer>().WithMany()
                        .HasForeignKey("CustomerId")
                        .OnDelete(DeleteBehavior.ClientSetNull)
                        .HasConstraintName("FK_CustomerCustomerDemo_Customers"),
                    j =>
                    {
                        j.HasKey("CustomerId", "CustomerTypeId").IsClustered(false);
                        j.ToTable("CustomerCustomerDemo");
                        j.IndexerProperty<string>("CustomerId")
                            .HasMaxLength(5)
                            .IsFixedLength();
                        j.IndexerProperty<string>("CustomerTypeId")
                            .HasMaxLength(10)
                            .IsFixedLength()
                            .HasColumnName("CustomerTypeID");
                    });
        });

        modelBuilder.Entity<CustomerAndSuppliersByCity>(encja =>
        {
            encja.ToView("Klienci i dostawcy według miasta");
        });

        modelBuilder.Entity<CustomerDemographic>(encja =>
        {
            encja.HasKey(e => e.CustomerTypeId).IsClustered(false);

            encja.Property(e => e.CustomerTypeId).IsFixedLength();
        });

        modelBuilder.Entity<Employee>(encja =>
        {
            encja.HasOne(d => d.ReportsToNavigation).WithMany(p => p.InverseReportsToNavigation).HasConstraintName("FK_Employees_Employees");

            encja.HasMany(d => d.Territories).WithMany(p => p.Employees)
                .UsingEntity<Dictionary<string, object>>(
                    "EmployeeTerritory",
                    r => r.HasOne<Territory>().WithMany()
                        .HasForeignKey("TerritoryId")
                        .OnDelete(DeleteBehavior.ClientSetNull)
                        .HasConstraintName("FK_EmployeeTerritories_Territories"),
                    l => l.HasOne<Employee>().WithMany()
                        .HasForeignKey("EmployeeId")
                        .OnDelete(DeleteBehavior.ClientSetNull)
                        .HasConstraintName("FK_EmployeeTerritories_Employees"),
                    j =>
                    {
                        j.HasKey("EmployeeId", "TerritoryId").IsClustered(false);
                        j.ToTable("EmployeeTerritories");
                        j.IndexerProperty<string>("TerritoryId")
                            .HasMaxLength(20)
                            .HasColumnName("TerritoryID");
                    });
        });

        modelBuilder.Entity<Invoice>(encja =>
        {
            encja.ToView("Invoices");

            encja.Property(e => e.CustomerId).IsFixedLength();
        });

        modelBuilder.Entity<Order>(encja =>
        {
            encja.Property(e => e.CustomerId).IsFixedLength();
            encja.Property(e => e.Freight).HasDefaultValue(0m);

            encja.HasOne(d => d.Customer).WithMany(p => p.Orders).HasConstraintName("FK_Orders_Customers");

            encja.HasOne(d => d.Employee).WithMany(p => p.Orders).HasConstraintName("FK_Orders_Employees");

            encja.HasOne(d => d.ShipViaNavigation).WithMany(p => p.Orders).HasConstraintName("FK_Orders_Shippers");
        });

        modelBuilder.Entity<OrderDetail>(encja =>
        {
            encja.HasKey(e => new { e.OrderId, e.ProductId }).HasName("PK_Order_Details");

            encja.Property(e => e.Quantity).HasDefaultValue((short)1);

            encja.HasOne(d => d.Order).WithMany(p => p.OrderDetails)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_Order_Details_Orders");

            encja.HasOne(d => d.Product).WithMany(p => p.OrderDetails)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_Order_Details_Products");
        });

        modelBuilder.Entity<OrderDetailsExtended>(encja =>
        {
            encja.ToView("Order Details Extended");
        });

        modelBuilder.Entity<OrderSubtotal>(encja =>
        {
            encja.ToView("Order Subtotals");
        });

        modelBuilder.Entity<OrdersQry>(encja =>
        {
            encja.ToView("Orders Qry");

            encja.Property(e => e.CustomerId).IsFixedLength();
        });

        modelBuilder.Entity<Product>(encja =>
        {
            encja.Property(e => e.Discontinued).HasDefaultValue(false);
            encja.Property(e => e.ReorderLevel).HasDefaultValue((short)0);
            encja.Property(e => e.UnitPrice).HasDefaultValue(0m);
            encja.Property(e => e.UnitsInStock).HasDefaultValue((short)0);
            encja.Property(e => e.UnitsOnOrder).HasDefaultValue((short)0);

            encja.HasOne(d => d.Category).WithMany(p => p.Products).HasConstraintName("FK_Products_Categories");

            encja.HasOne(d => d.Supplier).WithMany(p => p.Products).HasConstraintName("FK_Products_Suppliers");
        });

        modelBuilder.Entity<ProductSalesFor1997>(encja =>
        {
            encja.ToView("Product Sales for 1997");
        });

        modelBuilder.Entity<ProductsAboveAveragePrice>(encja =>
        {
            encja.ToView("Products Above Average Price");
        });

        modelBuilder.Entity<ProductsByCategory>(encja =>
        {
            encja.ToView("Products by Category");
        });

        modelBuilder.Entity<QuarterlyOrder>(encja =>
        {
            encja.ToView("Quarterly Orders");

            encja.Property(e => e.CustomerId).IsFixedLength();
        });

        modelBuilder.Entity<Region>(encja =>
        {
            encja.HasKey(e => e.RegionId).IsClustered(false);

            encja.Property(e => e.RegionId).ValueGeneratedNever();
            encja.Property(e => e.RegionDescription).IsFixedLength();
        });

        modelBuilder.Entity<SalesByCategory>(encja =>
        {
            encja.ToView("Sales by Category");
        });

        modelBuilder.Entity<SalesTotalsByAmount>(encja =>
        {
            encja.ToView("Sales Totals by Amount");
        });

        modelBuilder.Entity<SummaryOfSalesByQuarter>(encja =>
        {
            encja.ToView("Summary of Sales by Quarter");
        });

        modelBuilder.Entity<SummaryOfSalesByYear>(encja =>
        {
            encja.ToView("Summary of Sales by Year");
        });

        modelBuilder.Entity<Territory>(encja =>
        {
            encja.HasKey(e => e.TerritoryId).IsClustered(false);

            encja.Property(e => e.TerritoryDescription).IsFixedLength();

            encja.HasOne(d => d.Region).WithMany(p => p.Territories)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_Territories_Region");
        });

        OnModelCreatingPartial(modelBuilder);
    }

    partial void OnModelCreatingPartial(ModelBuilder modelBuilder);
}
